<?php
require_once '../config/database.php';
require_once '../config/session.php';

// hanya terima POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: ../modules/dashboard/index.php");
    exit;
}

$aksi = $_POST['aksi'] ?? '';

$anggota_id = $_POST['anggota_id'] ?? '';
$jumlah     = $_POST['jumlah'] ?? 0;

if ($anggota_id == '' || $jumlah <= 0) {
    $_SESSION['error'] = "Data tidak valid";
    header("Location: ../modules/simpanan/pokok.php");
    exit;
}

// tentukan jenis simpanan
if ($aksi == 'pokok') {
    $jenis = 'pokok';
} elseif ($aksi == 'wajib') {
    $jenis = 'wajib';
} elseif ($aksi == 'sukarela') {
    $jenis = 'sukarela';
} else {
    $_SESSION['error'] = "Aksi tidak dikenali";
    header("Location: ../modules/dashboard/index.php");
    exit;
}

// simpan ke database
$stmt = $db->prepare(
    "INSERT INTO simpanan (anggota_id, jenis, jumlah) VALUES (?, ?, ?)"
);
$stmt->bind_param("isd", $anggota_id, $jenis, $jumlah);

if ($stmt->execute()) {
    $_SESSION['success'] = "Simpanan berhasil disimpan";
} else {
    $_SESSION['error'] = "Gagal menyimpan simpanan";
}

$stmt->close();

// redirect sesuai jenis
header("Location: ../modules/simpanan/$jenis.php");
exit;
<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/session.php';

// Pastikan login
if (!isset($_SESSION['user'])) {
    header("Location: ../login.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| SIMPANAN POKOK
|--------------------------------------------------------------------------
*/
if (isset($_POST['simpan_pokok'])) {

    $anggota_id = intval($_POST['anggota_id']);
    $jumlah     = floatval($_POST['jumlah']);
    $tanggal    = $_POST['tanggal'];

    if ($anggota_id <= 0 || $jumlah <= 0) {
        $_SESSION['error'] = 'Data simpanan tidak valid';
        header("Location: ../modules/simpanan/pokok_tambah.php");
        exit;
    }

    $stmt = $conn->prepare("
        INSERT INTO simpanan (anggota_id, jenis, jumlah, tanggal)
        VALUES (?, 'pokok', ?, ?)
    ");
    $stmt->bind_param("ids", $anggota_id, $jumlah, $tanggal);

    if ($stmt->execute()) {
        $_SESSION['success'] = 'Simpanan pokok berhasil disimpan';
        header("Location: ../modules/simpanan/pokok.php");
        exit;
    } else {
        $_SESSION['error'] = 'Gagal menyimpan simpanan pokok';
        header("Location: ../modules/simpanan/pokok_tambah.php");
        exit;
    }
}
/*
|--------------------------------------------------------------------------
| SIMPANAN WAJIB
|--------------------------------------------------------------------------
*/
if (isset($_POST['simpan_wajib'])) {

    $anggota_id = intval($_POST['anggota_id']);
    $jumlah     = floatval($_POST['jumlah']);
    $tanggal    = $_POST['tanggal'];

    if ($anggota_id <= 0 || $jumlah <= 0) {
        $_SESSION['error'] = 'Data simpanan tidak valid';
        header("Location: ../modules/simpanan/wajib_tambah.php");
        exit;
    }

    $stmt = $conn->prepare("
        INSERT INTO simpanan (anggota_id, jenis, jumlah, tanggal)
        VALUES (?, 'wajib', ?, ?)
    ");
    $stmt->bind_param("ids", $anggota_id, $jumlah, $tanggal);

    if ($stmt->execute()) {
        $_SESSION['success'] = 'Simpanan wajib berhasil disimpan';
        header("Location: ../modules/simpanan/wajib.php");
        exit;
    } else {
        $_SESSION['error'] = 'Gagal menyimpan simpanan wajib';
        header("Location: ../modules/simpanan/wajib_tambah.php");
        exit;
    }
}
